#!/bin/sh

set -e

if [ $(/usr/bin/id -u) -ne 0 ]; then
  echo "This script must be run as root (i.e.: sudo ./install.sh)"
  exit 1
fi

if [ $# -ne 1 ]; then
  echo "You must provide one argument, the path to the desired installation directory."
  exit 1
fi

echo "Installing NetLogo-7.0.0 to $1..."
echo "Copying main directory."

cp -r . $1/NetLogo-7.0.0

echo "Creating .desktop file for NetLogo."

cat > /usr/share/applications/NetLogo-7.0.0.desktop << EOL
[Desktop Entry]
Version=1.0
Type=Application
Name=NetLogo 7.0.0
Exec=$1/NetLogo-7.0.0/bin/NetLogo
Icon=$1/NetLogo-7.0.0/icons/NetLogo.png
Terminal=false
Categories=Education;Science;Java
EOL

echo "Creating .desktop file for NetLogo3D."

cat > /usr/share/applications/NetLogo3D-7.0.0.desktop << EOL
[Desktop Entry]
Version=1.0
Type=Application
Name=NetLogo3D 7.0.0
Exec=$1/NetLogo-7.0.0/bin/NetLogo3D
Icon=$1/NetLogo-7.0.0/icons/NetLogo3D.png
Terminal=false
Categories=Education;Science;Java
EOL

echo "Creating .desktop file for HubNetClient."

cat > /usr/share/applications/HubNetClient-7.0.0.desktop << EOL
[Desktop Entry]
Version=1.0
Type=Application
Name=HubNetClient 7.0.0
Exec=$1/NetLogo-7.0.0/bin/HubNetClient
Icon=$1/NetLogo-7.0.0/icons/HubNetClient.png
Terminal=false
Categories=Education;Science;Java
EOL

echo "Creating .desktop file for Behaviorsearch."

cat > /usr/share/applications/Behaviorsearch-7.0.0.desktop << EOL
[Desktop Entry]
Version=1.0
Type=Application
Name=Behaviorsearch 7.0.0
Exec=$1/NetLogo-7.0.0/bin/Behaviorsearch
Icon=$1/NetLogo-7.0.0/icons/Behaviorsearch.png
Terminal=false
Categories=Education;Science;Java
EOL

echo "Updating .desktop file database."

update-desktop-database

echo "Installation complete!"
